(* integer expression parser *)
(* solyga@gmx.de, 2025-08-28 *)
IMPLEMENTATION MODULE IP;

IMPORT Lib, Str, IO, Ints, Config;
FROM CS IMPORT Read, TSymbol, TPosition, sym, pos, num, OutStr;

TYPE
  TValue = Ints.TValue;


PROCEDURE Err( s-: ARRAY OF CHAR );
BEGIN
  DEC( pos );
  IO.WrStr( '(' );
  IO.WrCard( pos, 1 );
  IO.WrStr( ') Parser error: ' );
  IO.WrStr( s );
  IO.WrStr( '.' );
  IO.WrLn();
  OutStr();
  (* show position -- function requires tab to be an invalid char ! *)
  IO.WrCharRep( '_', pos );
  IO.WrChar( '^' );
  IO.WrLn();
  HALT;
END Err;


PROCEDURE Neg( VAR x: TValue );
BEGIN
  IF ~ Ints.Neg( x ) THEN Err( 'Neg failed' ) END;
END Neg;

PROCEDURE Inc( VAR x: TValue; y: TValue );
BEGIN
  IF ~ Ints.Inc( x, y ) THEN Err( 'Inc failed' ) END;
END Inc;

PROCEDURE Dec( VAR x: TValue; y: TValue );
BEGIN
  IF ~ Ints.Dec( x, y ) THEN Err( 'Dec failed' ) END;
END Dec;

PROCEDURE Mpl( VAR x: TValue; y: TValue );
BEGIN
  IF ~ Ints.Mpl( x, y ) THEN Err( 'Mpl failed' ) END;
END Mpl;

PROCEDURE Dvd( VAR x: TValue; y: TValue );
VAR r: TValue;
BEGIN
  IF Config.data.sdv THEN
    IF ~ Ints.Dvd2( x, y, r ) THEN Err( 'Dvd failed' ) END;
  ELSE
    IF ~ Ints.Dvd( x, y, r ) THEN Err( 'Dvd failed' ) END;
  END;
END Dvd;

PROCEDURE Mod( VAR x: TValue; y: TValue );
VAR r: TValue;
BEGIN
  IF Config.data.sdv THEN
    IF ~ Ints.Dvd2( x, y, r ) THEN Err( 'Mod failed' ) END;
  ELSE
    IF ~ Ints.Dvd( x, y, r ) THEN Err( 'Mod failed' ) END;
  END;
  x := r;
END Mod;


(* synt = expr .
 * expr = [ "+" |"-" ] term { ( "+" | "-" ) term } .
 * term = fact { ( "*" | "/" | "%" ) fact } .
 * fact = number | "(" expr ")" .
 *)

PROCEDURE Expression( VAR val: TValue );

  PROCEDURE Factor( VAR val: TValue );
  BEGIN
    IF sym = sNum THEN
      val.v := num; val.n := FALSE; Read();
    ELSIF sym = sLPar THEN
      Read(); Expression( val );
      IF sym = sRPar THEN Read() ELSE Err( 'Expected operator or ")"' ) END;
    ELSE
      Err( 'Expected number or "("' );
    END;
  END Factor;

  PROCEDURE Term( VAR val: TValue );
  VAR
    op: TSymbol;
    x: TValue;
  BEGIN
    Factor( val );
    WHILE ( sym = sMul ) OR ( sym = sDiv ) OR ( sym = sMod ) DO
      op := sym; Read(); Factor( x );
      IF op = sMul THEN Mpl( val, x ) ELSIF op = sDiv THEN Dvd( val, x ) ELSE Mod( val, x ) END;
    END;
  END Term;

VAR
  op: TSymbol;
  x: TValue;
BEGIN
  IF ( sym = sPlus ) OR ( sym = sMinus ) THEN
    op := sym; Read(); Term( val );
    IF op = sMinus THEN Neg( val ) END;
  ELSE
    Term( val );
  END;
  WHILE ( sym = sPlus ) OR ( sym = sMinus ) DO
    op := sym; Read(); Term( x );
    IF op = sPlus THEN Inc( val, x ) ELSE Dec( val, x ) END;
  END;
END Expression;


PROCEDURE Run();
VAR
  val: TValue;
  str: ARRAY [0..SIZE(Config.data.str)-1] OF CHAR;
BEGIN
  Read();
  Expression( val );
  IF sym # sEOS THEN Err( 'Expected operator or EOS' ) END;

  IF ~ Ints.MkStr( str, val, Config.data.bo ) THEN
    Err( 'BUG: Output conversion failed' );
  END;
  IO.WrStr( str );
  IO.WrLn();
END Run;

END IP.
