(* Console Signals *)
(* solyga@gmx.de, 2019-06-21 *)
IMPLEMENTATION MODULE ConSigs;

IMPORT WinDef, WinCon;
IMPORT IO;

TYPE
  TCtrlTypes = SET OF WinCon.CTRL_TYPE;

CONST
  cts = TCtrlTypes{
    WinCon.CTRL_C_EVENT,
    WinCon.CTRL_BREAK_EVENT,
    WinCon.CTRL_CLOSE_EVENT,
    WinCon.CTRL_TYPE_3,
    WinCon.CTRL_TYPE_4,
    (*
    WinCon.CTRL_LOGOFF_EVENT,
    *)
    WinCon.CTRL_SHUTDOWN_EVENT
  };


PROCEDURE Message( s-: ARRAY OF CHAR );
BEGIN
  IO.WrStr( 'ConSigs: ' );
  IO.WrStr( s );
  IO.WrLn();
END Message;


(* docs.microsoft.com/SetConsoleCtrlHandler:
  If the function handles the control signal, it should return TRUE.
  If it returns FALSE, the next handler function in the list of handlers
  for this process is used.
*)
PROCEDURE ["StdCall"] Handler( ct: WinCon.CTRL_TYPE ): WinDef.BOOL;
BEGIN
  IF ct IN cts THEN
    Message( 'Signal received, terminating.' );
    HALT;
    RETURN TRUE;
  END;
  RETURN FALSE;
END Handler;

BEGIN
  IF ~ WinCon.SetConsoleCtrlHandler( Handler, TRUE ) THEN
    Message( 'Installation failed.' );
    HALT;
  END;
END ConSigs.
