IMPLEMENTATION MODULE IntsTst;

FROM SYSTEM IMPORT BYTE;
IMPORT IO, Types, Ints, LC;


PROCEDURE WrHex( x: ARRAY OF BYTE );
VAR
  c: CHAR;
  i, m: CARDINAL;
BEGIN
  c := IO.PrefixChar;
  IO.PrefixChar := '0';
  m := SIZE( x ) - 1;
  FOR i := 0 TO m DO
    IO.WrShtHex( Types.TShtCard(x[i]), 2 );
    IF i < m THEN IO.WrChar( ' ' ) END;
  END;
  IO.PrefixChar := c;
END WrHex;

PROCEDURE WrVal( x: Ints.TValue; b: Ints.TSht );
VAR
  s: ARRAY [0..127] OF CHAR;
BEGIN
  IF ~ Ints.MkStr( s, x, b ) THEN
    IO.WrStr( 'IntsTst.WrVal ERROR' );
    HALT;
  END;
  IO.WrStr( s );
END WrVal;


PROCEDURE Chk0();

  PROCEDURE Chk( x, y: INTEGER );
  BEGIN
    IO.WrStr( 'Chk:  ' );
    IO.WrInt( x, 2 );
    IO.WrStr( ' DIV ' );
    IO.WrInt( y, 1 );
    IO.WrStr( ' = ' );
    IO.WrInt( x DIV y, 2 );
    IO.WrStr( '    ' );
    IO.WrInt( x, 2 );
    IO.WrStr( ' MOD ' );
    IO.WrInt( y, 1 );
    IO.WrStr( ' = ' );
    IO.WrInt( x MOD y, 2 );
    IO.WrLn();
  END Chk;

BEGIN
  Chk( 1, 4 );
  Chk( -1, 4 );
  (* xc raises: zero or negative divisor
  Chk( 1, -4 );
  Chk( -1, -4 );
  *)
END Chk0;


PROCEDURE Chk1();

  PROCEDURE Chk( s-: ARRAY OF CHAR );
  CONST
    b = 10;
  VAR
    x: Ints.TValue;
    t: ARRAY [0..63] OF CHAR;
  BEGIN
    IO.WrStr( 'Chk1: ' ); IO.WrCard( SIZE(s), 2 ); IO.WrStr( ' "' ); IO.WrStr( s ); IO.WrStr( '"  ->  ' );
    IF ~ Ints.MkVal( x, s, b ) THEN
      IO.WrStr( 'MkVal failed' ); IO.WrLn(); RETURN;
    END;
    WrHex( x );
    IO.WrStr( '  ->  ' );
    IF ~ Ints.MkStr( t, x, b ) THEN
      IO.WrStr( 'MkStr failed' ); IO.WrLn(); RETURN;
    END;
    IO.WrChar( '"' );
    IO.WrStr( t );
    IO.WrChar( '"' );
    IO.WrLn();
  END Chk;

BEGIN
  Chk( '' );
  Chk( '-' );
  Chk( '+' );
  Chk( '0' );
  Chk( '-0' );
  Chk( '+0' );
  Chk( '-2' );
  Chk( '+12345' );
END Chk1;

PROCEDURE Chk2();

  PROCEDURE Eval( VAR x: Ints.TValue; s-: ARRAY OF CHAR; b: Ints.TSht );
  BEGIN
    IF ~ Ints.MkVal( x, s, b ) THEN
      IO.WrStr( 'IntsTst.Chk2.Eval ERROR' ); IO.WrLn(); HALT;
    END;
  END Eval;

  PROCEDURE Div( s-, t-: ARRAY OF CHAR );
  CONST
    b = 10;
  VAR
    x, y, z, r: Ints.TValue;
  BEGIN
    Eval( x, s, b );
    Eval( y, t, b );
    IO.WrStr( 'Chk2: ' ); WrVal( x, b ); IO.WrStr( ' DIV ' ); WrVal( y, b ); IO.WrStr( ' = ' );
    IF ~ Ints.DivT( x, y, z, r ) THEN
      IO.WrStr( 'DivT failed' ); IO.WrLn(); RETURN;
    END;
    WrVal( z, b ); IO.WrStr( ', ' ); WrVal( r, b );
    IO.WrLn();
  END Div;

  PROCEDURE Mul( s-, t-: ARRAY OF CHAR );
  CONST
    b = 10;
  VAR
    x, y, z: Ints.TValue;
  BEGIN
    Eval( x, s, b );
    Eval( y, t, b );
    IO.WrStr( 'Chk2: ' ); WrVal( x, b ); IO.WrStr( ' * ' ); WrVal( y, b ); IO.WrStr( ' = ' );
    IF ~ Ints.Mul( x, y, z ) THEN
      IO.WrStr( 'Mul failed' ); IO.WrLn(); RETURN;
    END;
    WrVal( z, b );
    IO.WrLn();
  END Mul;

  PROCEDURE Mpl( s-, t-: ARRAY OF CHAR );
  CONST
    b = 10;
  VAR
    x, y: Ints.TValue;
  BEGIN
    Eval( x, s, b );
    Eval( y, t, b );
    IO.WrStr( 'Chk2: ' ); WrVal( x, b ); IO.WrStr( ' * ' ); WrVal( y, b ); IO.WrStr( ' = ' );
    IF ~ Ints.Mpl( x, y ) THEN
      IO.WrStr( 'Mpl failed' ); IO.WrLn(); RETURN;
    END;
    WrVal( x, b );
    IO.WrLn();
  END Mpl;

BEGIN
  Div( '4', '4' );
  Div( '1', '4' );
  Div( '0', '4' );
  Div( '-1', '4' );
  Div( '-4', '4' );
  Div( '1', '-1' );
  Mul( '2', '3' );
  Mul( '-2', '3' );
  Mul( '2', '-3' );
  Mul( '-2', '-3' );
  Mpl( '2', '3' );
END Chk2;

PROCEDURE Chk3();

  PROCEDURE Eval( VAR x: Ints.TValue; i: INTEGER );
  VAR c: CARDINAL;
  BEGIN
    x.n := i < 0;
    c := ABS( i );
    IF ~ LC.Cpy( x.v, c ) THEN
      IO.WrStr( 'IntsTst.Chk3.Eval ERROR' ); IO.WrLn(); HALT;
    END;
  END Eval;

  PROCEDURE Div( f: CHAR; x-, y-: Ints.TValue; VAR z, r: Ints.TValue ): BOOLEAN;
  VAR
    ok: BOOLEAN;
    a: Ints.TValue;
  BEGIN
    CASE f OF
    | 'T': ok := Ints.DivT( x, y, z, r );
    | 'F': ok := Ints.DivF( x, y, z, r );
    | 'E': ok := Ints.DivE( x, y, z, r );
    | 'C': ok := Ints.DivC( x, y, z, r );
    | 'R': ok := Ints.DivR( x, y, z, r );
    ELSE
      ok := FALSE;
    END;
    IF ~ ok THEN
      IO.WrStr( 'IntsTst.Chk3.Div' ); IO.WrChar( f ); IO.WrStr( ' ERROR 1' ); IO.WrLn(); HALT;
    END;
    IF ~ Ints.Mul( y, z, a ) OR ~ Ints.Inc( a, r ) OR ~ Ints.Dec( a, x ) THEN
      IO.WrStr( 'IntsTst.Chk3.Div' ); IO.WrChar( f ); IO.WrStr( ' ERROR 2' ); IO.WrLn(); HALT;
    END;
    IF ~ Ints.IsZero( a ) THEN
      IO.WrStr( 'IntsTst.Chk3.Div' ); IO.WrChar( f ); IO.WrStr( ' ERROR 3' ); IO.WrLn(); HALT;
    END;
    IF LC.Cmp( r.v, y.v ) >= 0 THEN
      IO.WrStr( 'IntsTst.Chk3.Div' ); IO.WrChar( f ); IO.WrStr( ' ERROR 4' ); IO.WrLn(); HALT;
    END;
    RETURN TRUE;
  END Div;

  PROCEDURE DivX( f: CHAR; b: INTEGER );
  VAR
    a: INTEGER;
    x, y, z, r: Ints.TValue;
  BEGIN
    IO.WrStr( 'IntsTst.Chk3.Div' ); IO.WrChar( f ); IO.WrStr( ' test, b = ' ); IO.WrInt( b, 1 ); IO.WrLn();
    FOR a := -5 TO 5 DO
      Eval( x, a ); Eval( y, b );
      IF ~ Div( f, x, y, z, r ) THEN
        IO.WrStr( 'Div failed' ); IO.WrLn(); RETURN;
      END;
      WrVal( x, 10 ); IO.WrStr( ' DIV ' ); WrVal( y, 10 ); IO.WrStr( ' = ' );
      WrVal( z, 10 ); IO.WrStr( ' rem ' ); WrVal( r, 10 ); IO.WrLn();
    END;
  END DivX;

  PROCEDURE DivTst( f: CHAR );
  BEGIN
    DivX( f, 2 );
    DivX( f, 3 );
    DivX( f, -2 );
    DivX( f, -3 );
  END DivTst;

BEGIN
  DivTst( 'R' );
END Chk3;

BEGIN
  Chk3();
END IntsTst.
