(* real scanner *)
(* solyga@gmx.de, 2025-08-29 *)
IMPLEMENTATION MODULE RS;

IMPORT Str, IO, Config, Reals;

VAR
  len: CARDINAL;
  idx: CARDINAL;
  chr: CHAR;


PROCEDURE Err( s-: ARRAY OF CHAR );
BEGIN
  DEC( idx );
  IO.WrStr( '(' );
  IO.WrCard( idx, 1 );
  IO.WrStr( ') Scanner error: ' );
  IO.WrStr( s );
  IO.WrStr( '.' );
  IO.WrLn();
  OutStr();
  (* show position -- function requires tab to be an invalid char ! *)
  IO.WrCharRep( '_', idx );
  IO.WrChar( '^' );
  IO.WrLn();
  HALT;
END Err;


PROCEDURE Get();
BEGIN
  IF idx < len THEN
    chr := Config.data.str[ idx ];
    INC( idx );
  ELSIF idx = len THEN
    chr := 0C;
    INC( idx );
  ELSE
    chr := 0C;
  END;
END Get;

PROCEDURE Number();
VAR
  e: INTEGER;

  PROCEDURE Exp();
  VAR
    exp: CARDINAL;
    neg: BOOLEAN;
  BEGIN
    exp := 0;
    neg := FALSE;
    IF chr = '-' THEN neg := TRUE; Get() ELSIF chr = '+' THEN Get() END;
    WHILE ( '0' <= chr ) & ( chr <= '9' ) DO
      exp := exp * 10 + ( ORD(chr) - ORD('0') );
      Get();
    END;
    IF neg THEN DEC( e, exp ) ELSE INC( e, exp ) END;
  END Exp;

BEGIN
  e := 0;
  Reals.Zero( num );
  WHILE ( '0' <= chr ) & ( chr <= '9' ) DO
    Reals.Mpl10( num );
    Reals.IncD( num, ORD(chr) - ORD('0') );
    Get();
  END;
  IF chr = '.' THEN Get() END;
  WHILE ( '0' <= chr ) & ( chr <= '9' ) DO
    Reals.Mpl10( num );
    Reals.IncD( num, ORD(chr) - ORD('0') );
    DEC( e );
    Get();
  END;
  IF CAP( chr ) = 'E' THEN Get(); Exp() END;
  WHILE e > 0 DO Reals.Mpl10( num ); DEC( e ) END;
  WHILE e < 0 DO Reals.Div10( num ); INC( e ) END;
END Number;

PROCEDURE Read();
BEGIN
  LOOP (* ignore control characters except EOS *)
    IF chr <= ' ' THEN
      IF chr = 0C THEN EXIT END;
      Get();
    ELSIF chr >= 177C THEN
      Get();
    ELSE
      EXIT;
    END;
  END;
  pos := idx;
  CASE chr OF
  | 0C : sym := sEOS;
  | '(': sym := sLPar; Get();
  | ')': sym := sRPar; Get();
  | '+': sym := sPlus; Get();
  | '-': sym := sMinus; Get();
  | '*': sym := sMul; Get();
  | '/': sym := sDiv; Get();
  | '.',
    '0'..'9': sym := sNum; Number();
  ELSE
    Err( 'Invalid character' )
  END;
END Read;

PROCEDURE OutStr();
BEGIN
  IO.WrStr( Config.data.str ); IO.WrLn();
END OutStr;

BEGIN
  sym := sNull;
  pos := 0;
  Reals.Zero( num );
  len := Str.Length( Config.data.str );
  idx := 0;
  chr := 0C;
  Get();
END RS.
