IMPLEMENTATION MODULE Reals;

FROM SYSTEM IMPORT BYTE;
IMPORT Str, Lib2;
IMPORT IO;

CONST
  val0  = 0.0;
  val10 = 10.0;
  val1  = 1.0;
  val01 = 0.1;


PROCEDURE Inc( VAR x: TValue; y: TValue );
BEGIN
  x := x + y;
END Inc;

PROCEDURE Dec( VAR x: TValue; y: TValue );
BEGIN
  x := x - y;
END Dec;

PROCEDURE Mpl( VAR x: TValue; y: TValue );
BEGIN
  x := x * y;
END Mpl;

PROCEDURE Dvd( VAR x: TValue; y: TValue );
BEGIN
  IF y = val0 THEN IO.WrStr( 'Divison by zero' ); IO.WrLn(); HALT END;
  x := x / y;
END Dvd;


PROCEDURE Zero( VAR x: TValue );
BEGIN
  Lib2.Fill( x, 0 );
END Zero;

PROCEDURE Val( VAR x: TValue; d: TSht );
BEGIN
  x := TValue( d );
END Val;

PROCEDURE Neg( VAR x: TValue );
BEGIN
  x := -x;
END Neg;


PROCEDURE Mpl10( VAR x: TValue );
BEGIN
  Mpl( x, val10 );
END Mpl10;

PROCEDURE Div10( VAR x: TValue );
BEGIN
  Mpl( x, val01 );
END Div10;

PROCEDURE IncD( VAR x: TValue; d: TSht );
VAR v: TValue;
BEGIN
  Val( v, d );
  Inc( x, v );
END IncD;

PROCEDURE Trunc( x: TValue ): INTEGER;
BEGIN
  RETURN TRUNC( x );
END Trunc;


PROCEDURE MkVal( VAR x: TValue; s-: ARRAY OF CHAR ): BOOLEAN;
VAR
  l, i: CARDINAL;
  e: INTEGER;
  n: BOOLEAN;
  c: CHAR;

  PROCEDURE Get();
  BEGIN
    IF i < l THEN c := CAP( s[i] ); INC( i ) ELSE c := 0C END;
  END Get;

  PROCEDURE Exp();
  VAR
    exp: CARDINAL;
    neg: BOOLEAN;
  BEGIN
    exp := 0;
    neg := FALSE;
    IF c = '-' THEN neg := TRUE; Get() ELSIF c = '+' THEN Get() END;
    WHILE ( '0' <= c ) & ( c <= '9' ) DO
      exp := exp * 10 + ( ORD(c) - ORD('0') );
      Get();
    END;
    IF neg THEN DEC( e, exp ) ELSE INC( e, exp ) END;
  END Exp;

BEGIN
  l := Str.Length( s );
  IF l = 0 THEN RETURN FALSE END;
  i := 0;
  e := 0;
  n := FALSE;
  Zero( x );
  Get();
  IF ( c = '+' ) OR ( c = '-' ) THEN
    IF c = '-' THEN n := TRUE END;
    Get();
  END;
  WHILE ( '0' <= c ) & ( c <= '9' ) DO
    Mpl10( x ); IncD( x, ORD(c) - ORD('0') );
    Get();
  END;
  IF c = '.' THEN Get() END;
  WHILE ( '0' <= c ) & ( c <= '9' ) DO
    Mpl10( x ); IncD( x, ORD(c) - ORD('0') );
    DEC( e );
    Get();
  END;
  IF c = 'E' THEN Get(); Exp() END;
  WHILE e > 0 DO Mpl10( x ); DEC( e ) END;
  WHILE e < 0 DO Div10( x ); INC( e ) END;
  IF n THEN Neg( x ) END;
  RETURN c = 0C;
END MkVal;


PROCEDURE Invert( VAR s: ARRAY OF CHAR; a, b: CARDINAL );
VAR
  i, j: CARDINAL;
  c: CHAR;
BEGIN
  IF a > SIZE( s ) THEN a := SIZE( s ) END;
  IF b > SIZE( s ) THEN b := SIZE( s ) END;
  IF ( a > b ) OR ( b - a < 2 ) THEN RETURN END;
  FOR i := a TO a + ( b - a ) DIV 2 - 1 DO
    j := b - 1 - i + a;
    c := s[ i ]; s[ i ] := s[ j ]; s[ j ] := c;
  END;
END Invert;

PROCEDURE MkStr( VAR s: ARRAY OF CHAR; x: TValue; p: CARDINAL ): BOOLEAN;
VAR
  i: CARDINAL;

  PROCEDURE Put( c: CHAR );
  BEGIN
    IF i < SIZE( s ) THEN s[i] := c; INC( i ) END;
  END Put;

  PROCEDURE Chr( d: CARDINAL ): CHAR;
  BEGIN
    IF d < 10 THEN
      RETURN CHR( d + ORD( '0' ) );
    ELSE
      RETURN '?';
    END;
  END Chr;

VAR
  e: INTEGER;
  d: CARDINAL;
  y: TValue;
  a: CARDINAL;
BEGIN
  i := 0; e := 0;
  IF x < val0 THEN Neg( x ); Put( '-' ) END;
  IF x = val0 THEN
    (* done *)
  ELSE
    WHILE x >= val1 DO Mpl( x, val01 ); INC( e ) END;
    WHILE x < val01 DO Mpl( x, val10 ); DEC( e ) END;
    (* 0.1 <= x < 1.0 *)
  END;
  Put( '.' );
  WHILE p > 0 DO
    Mpl( x, val10 );
    d := Trunc( x );
    Put( Chr(d) );
    Val( y, d );
    Dec( x, y );
    DEC( p );
  END;
  Put( 'E' );
  IF e < 0 THEN e := -e; Put( '-' ) END;
  a := i;
  REPEAT
    d := e MOD 10;
    Put( Chr(d) );
    e := e DIV 10;
  UNTIL e = 0;
  Invert( s, a, i );
  Put( 0C );
  RETURN TRUE;
END MkStr;



PROCEDURE Test01();
CONST
  s = '-123.456E-3';
  v =  -123.456E-3;
VAR
  x: LONGREAL;
BEGIN
  IO.WrStr( 'Reals.Test01: ' );
  IF ~ MkVal( x, s ) THEN
    IO.WrStr( 'Invalid string' );
    IO.WrLn();
    HALT;
  END;
  IO.WrStr( s );
  IO.WrStr( ' = ' );
  IO.WrLngReal( x, 30, 0 );
  IO.WrStr( ' plus ' );
  IO.WrLngReal( v - x, 3, 0 );
  IO.WrLn();
END Test01;

PROCEDURE Test02();
CONST
  x = 12.3456789E08;
VAR
  s: ARRAY [0..63] OF CHAR;
BEGIN
  IO.WrStr( 'Reals.Test02: ' );
  IF ~ MkStr( s, x, 12 ) THEN
    IO.WrStr( 'MkStr failed' );
    IO.WrLn();
    HALT;
  END;
  IO.WrLngReal( x, 10, 0 );
  IO.WrStr( ' = ' );
  IO.WrStr( s );
  IO.WrLn();
END Test02;

PROCEDURE Test();
BEGIN
  (*
  Test01();
  Test02();
  *)
END Test;

BEGIN
  Test();
END Reals.
